function Enemies() {
    this.canvas = newCanvas(document.getElementById("content"), width, height, 300);
    this.context = this.canvas.getContext('2d');
    this.context.font = '12pt Arial';
      
    this.enemies = [];

    this.spawner = linerSpawner;

    this.proceed = function() {
        var newEnemies = this.spawner.spawn();
        if (newEnemies !== undefined) {
            this.enemies = this.enemies.concat(newEnemies);
        }
        var enemies = this.enemies;
        var len = enemies.length;
        while (len--) {
            var e = enemies[len]
            e.proceed(enemies);
            var p = particles.intersect(e.getBounds(), 'enemy');
            if (p !== null) {
                e.armor -= p.damage;
                particles.removeParticle(p);
            }
            if (e.position.y > height || e.armor <= 0) {
                enemies.splice(len, 1);
                e.die();
		if (e.armor <= 0) {
		    playerShips.ships[0].frags += 1;
		    var newLevel  = (playerShips.ships[0].frags / 5) | 0;
		    if (playerShips.ships[0].weapon.level < newLevel) {
		        playerShips.ships[0].armor = 100;
		    }
		    playerShips.ships[0].weapon.level = newLevel;
		    linerSpawner.maxAmount = (newLevel + 1) * 2;
		}
            }
        }
    };

    this.collide = function(ship, enemy) {
        return intersect(ship.getBounds(), enemy.getBounds());
    };

    this.repaint = function() {
        this.canvas.width = this.canvas.width;
        var enemies = this.enemies;
        for (var i = 0; i < enemies.length; i++) {
            enemies[i].repaint(this.context);
        }
    };
}

function Spawner(enemy, amount) {
    this.enemy = enemy;
    this.maxAmount = amount;
    this.count = 0;

    this.reloadDelay = 1;
    this.reloadSpeed = 0.1;

    this.spawn = function() {
        if (this.count < this.maxAmount) {
            if (this.reloadDelay < 0) {
                newEnemies = this.enemy(this);
                this.count += newEnemies.length;
                this.reloadDelay = 1;
                return newEnemies;
            }
            this.reloadDelay -= this.reloadSpeed;
        }
    };
}

linerSpawner = new Spawner(function(src) {
    var liner = new Liner(v(Math.random() * width, -10), src);
    return [liner];
}, 2);

function Liner(position, spawner) {
    this.position = position;
    this.alpha = 0;
    this.speed = enemySpeed;
    this.direction = v(0, this.speed);    
    this.dead = false;
    this.armor = 100;
    this.spawner = spawner;
    this.radius = 10;
    
    this.weapon = new Machinegun(function(pos) {
        var bullet = new Homing(pos, playerShips.ships[0]);
        bullet.owner = 'enemy';
        return bullet;
    });
    this.weapon.level = 0;
    this.weapon.reloadSpeed = 0.01;

    this.proceed = function() {
        var bullets = this.weapon.proceed(this.position);
        if (bullets !== undefined) {
            particles.particles = particles.particles.concat(bullets);
        }
        this.direction = add(this.direction, 
			     norm(v(playerShips.ships[0].position.x - this.position.x, playerShips.ships[0].position.y - this.position.y), this.speed));
        this.position = add(this.position, this.direction);
    };

    this.getBounds = function() {
        var p = this.position;
        return rect(p.x - this.radius, p.y - this.radius, p.x + this.radius, p.y + this.radius);
    };

    this.die = function() {
        this.spawner.count -= 1;
	for (var i = 0; i < 10; i++){
	    particles.particles.push(new Obstacle(this.position, shapes.triangle, this.color));
	}
    };
}