function Enemies() {
    this.canvas = newCanvas(document.getElementById("content"), width, height, 300);
    this.context = this.canvas.getContext('2d');
    this.context.font = '12pt Arial';
      
    this.enemies = [];

    this.spawner = linerSpawner;

    this.proceed = function() {
        var newEnemies = this.spawner.spawn();
        if (newEnemies !== undefined) {
            this.enemies = this.enemies.concat(newEnemies);
        }
        var enemies = this.enemies;
        var len = enemies.length;
        while (len--) {
            var e = enemies[len]
            e.proceed(enemies);
            var p = particles.intersect(e.getBounds(), 'enemy');
            if (p !== null) {
                e.armor -= p.damage;
                particles.removeParticle(p);
            }
            if (e.position.y > height || e.armor <= 0) {
                enemies.splice(len, 1);
                e.die();
            }
        }
    };

    this.collide = function(ship, enemy) {
        return intersect(ship.getBounds(), enemy.getBounds());
    };

    this.repaint = function() {
        this.canvas.width = this.canvas.width;
        var enemies = this.enemies;
        for (var i = 0; i < enemies.length; i++) {
            this.context.fillText(enemies[i].armor, enemies[i].position.x - 10, enemies[i].getBounds().a.y - 6);
            enemies[i].repaint(this.context);
        }
    };
}

function Spawner(enemy, amount) {
    this.enemy = enemy;
    this.maxAmount = amount;
    this.count = 0;

    this.reloadDelay = 1;
    this.reloadSpeed = 0.1;

    this.spawn = function() {
        if (this.count < this.maxAmount) {
            if (this.reloadDelay < 0) {
                newEnemies = this.enemy(this);
                this.count += newEnemies.length;
                this.reloadDelay = 1;
                return newEnemies;
            }
            this.reloadDelay -= this.reloadSpeed;
        }
    };
}

linerSpawner = new Spawner(function(src) {
    var liner = new Liner(v(Math.random() * width, -10), src);
    return [liner];
}, 10);

function Liner(position, spawner) {
    this.position = position;
    this.alpha = 0;
    this.speed = 0.01;
    this.direction = v(0, this.speed);    
    this.dead = false;
    this.armor = 100;
    this.spawner = spawner;
    
    this.weapon = new Machinegun(function(pos) {
        var bullet = new Homing(pos, playerShips.ships[0]);
        bullet.owner = 'enemy';
        return bullet;
    });
    this.weapon.level = 1;
    this.weapon.reloadSpeed = 0.01;

    this.proceed = function() {
        var bullets = this.weapon.proceed(this.position);
        if (bullets !== undefined) {
            particles.particles = particles.particles.concat(bullets);
        }
        this.direction = add(this.direction, norm(v(playerShips.ships[0].position.x - this.position.x, playerShips.ships[0].position.y - this.position.y), 0.01));
        this.position = add(this.position, this.direction);
    };

    this.getBounds = function() {
        var p = this.position;
        return rect(p.x - 10, p.y - 10, p.x + 10, p.y + 10);
    };

    this.die = function() {
        this.spawner.count -= 1;
    };
}