function Ship() {
    this.position = v(width / 2, height / 2);
    this.direction = v(0, 0);
    this.onfire = false;
    this.width = 50;
    this.height = 100;
    this.speed = 3;
    
    this.weapon = new Machinegun(function(pos, dir) {
        var bullet = new Bullet(pos, dir);
        bullet.speed = 5;
        return bullet;
    });

    this.proceed = function() {
        var bullet = particles.intersect(this.getBounds(), 'player');
        if (bullet !== null) {
            particles.removeParticle(bullet);
        }
        this.position = add(this.position, this.direction);
        var bounds = this.getBounds();
        if (bounds.b.x < 0) {
            this.position.x = width + bounds.b.x;
        } else if (bounds.a.x > width) {
            this.position.x = bounds.a.x - width;
        }
        if (this.onfire) {
            var bullets = this.weapon.proceed(this.position);
            if (bullets !== undefined) {
                particles.particles = particles.particles.concat(bullets);
            }
        }
    };

    this.fire = function(f) {
        this.onfire = f;
        this.fireDelay = -1;
    };

    this.getBounds = function() {
        var p = this.position;
        return rect(p.x - this.width / 2, p.y - this.height / 2, p.x + this.width / 2, p.y + this.height / 2);
    };
}

function PlayerShips() {
    this.canvas = newCanvas(document.getElementById("content"), width, height, 300);
    this.context = this.canvas.getContext('2d');
    this.ships = [new Ship()];

    this.repaint = function() {
        this.canvas.width = this.canvas.width;
        for (var i = 0; i < this.ships.length; i++) {
            this.ships[i].repaint(this.context);
        }
    };

    this.proceed = function() {
        for (var i = 0; i < this.ships.length; i++) {
            this.ships[i].proceed();
        }
    }
}


function Controls(ship) {
    this.ship = ship;

    $(document.body).on('keydown', function(e) {
        switch (e.which) {
            case 37:
                ship.direction.x = -1;
                break;
            case 38:
                ship.direction.y = -1;
                break;
            case 39:
                ship.direction.x = 1;
                break;
            case 40:
                ship.direction.y = 1;
                break;
            case 32:
                ship.fire(true);
                break;
        }
        ship.direction.x *= ship.speed;
        ship.direction.y *= ship.speed;
    });

    $(document.body).on('keyup', function(e) {
        switch (e.which) {
            case 38:
            case 40:
                ship.direction.y = 0;
                break;
            case 37:
            case 39:
                ship.direction.x = 0;
                break;
            case 32:
                ship.fire(false);
                break;
        }
    });
}
